/**
 * 
 */
package gov.va.med.mhv.integration.phr.service.cds;

import java.util.ArrayList;
import java.util.List;

import gov.va.med.mhv.integration.phr.service.Error;
import gov.va.med.mhv.integration.phr.service.ErrorSection;

/**
 * @author DNS
 *
 */
public class ChemistryErrorSection implements ErrorSection {
	
	private gov.va.med.mhv.cds.template.mhvlabread40011.ErrorSection errorSection;
	
	public ChemistryErrorSection(gov.va.med.mhv.cds.template.mhvlabread40011.ErrorSection errorSection) {
		if(errorSection == null) {
			throw new IllegalArgumentException("Invalid null error section.");
		}
		this.errorSection = errorSection;
	}
	
	@Override
	public List<Error> getWarnings() {
		return nullSafeWrap(this.errorSection.getWarnings());
	}

	@Override
	public List<Error> getErrors() {
		return nullSafeWrap(this.errorSection.getErrors());
	
	}
	
	@Override
	public List<Error> getFatalErrors() {
		return nullSafeWrap(this.errorSection.getFatalErrors());
	}
	
	private List<Error> nullSafeWrap(List<gov.va.med.mhv.cds.template.mhvlabread40011.Error> errors) {
		List<Error> wrappedErrors = null;
		if(errors != null) {
			wrappedErrors = new ArrayList<Error>();
			for(gov.va.med.mhv.cds.template.mhvlabread40011.Error e : this.errorSection.getErrors()) {
				wrappedErrors.add(new ChemistryError(e));
			}
		}
		return wrappedErrors;
	}
}
